/*
 * Decompiled with CFR 0.152.
 */
package cds.aladin.stc;

import cds.aladin.stc.STCCircle;
import cds.aladin.stc.STCFrame;
import cds.aladin.stc.STCObj;
import cds.aladin.stc.STCPolygon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class STCStringParser {
    public final int mandatoryStcCircleWords = 5;

    public List<STCObj> parse(String stcString) {
        return this.parse(stcString, false);
    }

    public List<STCObj> parse(String stcString, boolean reduced) {
        stcString = stcString.toUpperCase();
        ArrayList<STCObj> stcObjs = new ArrayList<STCObj>();
        String[] shapesStrs = this.splitShapesStrings(stcString, reduced);
        if (shapesStrs.length == 0) {
            reduced = true;
            shapesStrs = this.splitShapesStrings(stcString, reduced);
        }
        for (String shapeStr : shapesStrs) {
            List<String> stcWords = Arrays.asList(shapeStr.split("[ \t]+", -1));
            Iterator<String> itWords = stcWords.iterator();
            while (itWords.hasNext()) {
                String curWord = itWords.next();
                try {
                    if (curWord.equals("POLYGON")) {
                        stcObjs.add(this.parsePolygon(itWords, reduced));
                        continue;
                    }
                    if (!curWord.equals("CIRCLE") || !reduced && stcWords.size() != 5) continue;
                    stcObjs.add(this.parseCircle(itWords, reduced));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return stcObjs;
    }

    private String[] splitShapesStrings(String stcString, boolean reduced) {
        ArrayList<String> result = new ArrayList<String>();
        String shapes = new String("(");
        for (STCObj.ShapeType shapeType : STCObj.ShapeType.values()) {
            shapes = shapes + shapeType.name() + "|";
        }
        shapes = shapes.substring(0, shapes.length() - 1) + ")";
        String regexp = reduced ? shapes + "(\\s+[A-Za-z0-9]+)?(\\s+[-]?[0-9Ee\\+\\-\\.]+)+" : shapes + "(\\s+[A-Za-z0-9]+)+(\\s+[-]?[0-9Ee\\+\\-\\.]+)+";
        Pattern p = Pattern.compile(regexp);
        Matcher m = p.matcher(stcString);
        while (m.find()) {
            result.add(m.group());
        }
        return result.toArray(new String[result.size()]);
    }

    private double getDouble(String s) {
        return Double.parseDouble(s);
    }

    private STCPolygon parsePolygon(Iterator<String> itWords, boolean reduced) throws Exception {
        STCPolygon polygon = new STCPolygon();
        if (!reduced) {
            polygon.setFrame(STCFrame.valueOf(itWords.next()));
        } else {
            polygon.setFrame(STCFrame.ICRS);
        }
        while (itWords.hasNext()) {
            double dec = Double.NaN;
            double ra = Double.NaN;
            try {
                String nextParam = itWords.next();
                if (!this.isNumber(nextParam)) continue;
                ra = this.getDouble(nextParam);
                dec = this.getDouble(itWords.next());
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            polygon.addCorner(ra, dec);
        }
        return polygon;
    }

    private STCObj parseCircle(Iterator<String> stcWords, boolean reduced) {
        STCCircle circle = null;
        STCFrame frame = null;
        frame = !reduced ? STCFrame.valueOf(stcWords.next()) : STCFrame.ICRS;
        while (stcWords.hasNext()) {
            double rad;
            double dec = Double.NaN;
            double ra = Double.NaN;
            try {
                String nextParam = stcWords.next();
                if (!this.isNumber(nextParam)) continue;
                ra = this.getDouble(nextParam);
                dec = this.getDouble(stcWords.next());
                rad = this.getDouble(stcWords.next());
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            circle = new STCCircle(frame, ra, dec, rad);
            break;
        }
        return circle;
    }

    public boolean isNumber(String input) {
        for (char c : input.toCharArray()) {
            if (!Character.isLetter(c) || c == 'e' || c == 'E') continue;
            return false;
        }
        return true;
    }
}

